(function($){
	$.extend({
		dh :{
			/**
			 * 网页禁用右键
			 * @return:  bool
			 * @author   szj
			*/
			rightClick:function(){
				return false;
			},
			/**
			 * 屏蔽网页报错
			 * @return:  bool
			 * @author   szj
			*/
			killErrors:function(){ 
				return true; 
			},
			/**
			 * 禁止输入空格
			 * @author   szj
			*/
			checkKeyDown:function(){
				if(event.keyCode == 32){
					event.returnValue = false;   
					return;
				}
			},
			/**
			 * 屏蔽ESC
			 * @author	szj
			*/
			shielding:function(){
				if((event.keyCode == 27)){   
					event.keyCode = 0;   
			        event.returnValue = false;
					return;   
				} 
			},
			/**
			 * 文本框提示语
			 * @param obj		需要添加提示语的文本框
			 * @param notice 	提示语
			 * author jq_zhang
			*/
			addNotice:function(obj,notice){
				if(!obj) return;
				if(obj instanceof jQuery || obj.length>1){
					obj = obj[0];
				}
				var cover = $(obj).clone();
				var display = $(obj).css("display");
				$(cover).removeAttr("id").removeAttr("name");
				$(cover).val(notice);
				$(cover).css("color","gray");
				$(cover).css("display","none");
				$(cover).insertAfter($(obj));
				if($(obj).val()==""){
					$(obj).css("display","none");
					$(cover).css("display",display);
				}
				$(cover).click(function() {
					$(cover).css("display","none");
					$(obj).css("display",display);
					$(obj).focus();
				});
				$(obj).focusout(function() {
					if(obj.value==""){
						$(obj).css("display","none");
						$(cover).css("display",display);
					}
				});
			},
			/**
			 * 锁定当前页面
			 * @param 	imgPath 中心图片颜色
			 * @param 	color 锁屏颜色
			 * @param 	opacity 透明度
			 * @author	jquan_zhang
			*/
			lock:function(imgPath,color,opacity){
				var color = color,opacity=opacity;
				if(!color) color = "gray";
				if(!opacity) opacity = "0.2";
				var _ie6 = window.ActiveXObject && !window.XMLHttpRequest;
				var positionType = _ie6 ? 'absolute' : 'fixed';
				var	frm = '<iframe src="javascript:\'\'" style="width:100%;height:100%;position:absolute;' +
						'top:0;left:0;z-index:-1;filter:alpha(opacity=0)"></iframe>';
				var	mask = document.createElement('div');
				mask.id = 'lock_mask';
				mask.style.cssText = 'position:' + positionType + ';left:0;top:0;width:100%;height:100%;overflow:hidden;z-index:9998;';
				if( _ie6 ) mask.innerHTML = frm;	
				$("body").append(mask);
				$("#lock_mask").css({background:color,opacity:opacity});
				if( positionType === 'absolute' ){
					var lWidth = Math.max(document.documentElement.scrollWidth,document.documentElement.clientWidth);
					var lHeight = Math.max(document.documentElement.scrollHeight,document.documentElement.clientHeight);
					$("#lock_mask").css({
						"width":lWidth,
						"height":lHeight,
						"top":$("body").scrollTop(),
						"left":$("body").scrollLeft()
					});
				}
				//中心图片
				var lockImg = document.createElement('img');
				lockImg.id = "lock_mask_img";
				$("body").append(lockImg);
				lockImg.setAttribute("src",imgPath);
				$("#lock_mask_img").css({
					"position":positionType,
					"top":document.documentElement.clientHeight/2,
					"left":document.documentElement.clientWidth/2,
					"z-index":9999,
					"margin-top":-$("#lock_mask_img").outerHeight()/2,
					"margin-left":-$("#lock_mask_img").outerWidth()/2
				});
				if(_ie6){//IE6下静止图片
					window.attachEvent("onscroll",function(){
						$("#lock_mask_img").css({
							"margin-top":document.documentElement.scrollTop-$("#lock_mask_img").outerHeight()/2,
							"margin-left":document.documentElement.scrollLeft-$("#lock_mask_img").outerWidth()/2
						});	
					});
				}
				$(lockImg).load(function(){//图片加载后再次确定位置
					$("#lock_mask_img").css({
						"margin-top":-$("#lock_mask_img").outerHeight()/2,
						"margin-left":-$("#lock_mask_img").outerWidth()/2
					});
				})
			},
			/**
			 * 解除当前页面锁屏
			 * @author	jquan_zhang
			*/
			unlock:function(){
				$("#lock_mask").remove();
				$("#lock_mask_img").remove();
			},
			/**
			 * 检测字符串是否为空
			 * @param 	str 字符串
			 * @return 	bool
			 * @author	szj
			*/
			isNullOrEmpty:function(str){
			    str = this.trimStr(str);
			    if (str.length == 0) {
			        return true;
			    }
			    return false;
			},
			/**
			 * 去首尾空格
			 * @param 	str 字符串
			 * @return 	bool
			 * @author	szj
			*/
			trimStr:function(str){
    			return str.replace(/^\s*|\s*$/g, "");
			},
			/**
			 * 去所有空格
			 * @param 	str 字符串
			 * @param 	is_global g
			 * @return 	bool
			 * @author	szj
			*/
			trimStrGlobal:function(str){
			    return  str.replace(/(^\s+)|(\s+$)/g, "").replace(/\s/g, "");
			},
			/**
			 * 去左空格
			 * @param 	str 字符串
			 * @return 	bool
			 * @author	szj
			*/
			lTrimStr:function (str){
			    return str.replace(/^\s*/g, "");
			},
			/**
			 * 去右空格
			 * @param 	str 字符串
			 * @return 	bool
			 * @author	szj
			*/
			rTrimStr:function(str){
   	 			return str.replace(/\s*$/g, "");
			},
			/**
			 * 计算字符串的长度
			 * @param 	str 字符串
			 * @return 	iLength 长度 
			 * @author	szj
			*/
			judgeTextLength:function(str){
				var  iLength = 0;   
				for(var i=0; i<str.length; i++){   
					if(str.charCodeAt(i)>255){   
						iLength+=2;   
					}else{   
						iLength+=1;   
					}        
				}   
				return  iLength;    
			},
			/**
			 * 检查字符是否合法
			 * @param 	str 字符串
			 * @return 	bool 
			 * @author	szj
			*/
			checkString:function(str){
				var forbidChar = new Array("'",":",";","*","?","<",">","|", "/", "%","\\",'"', "\"");
				for(var i = 0;i < forbidChar.length ; i++){ 
			  		if(str.indexOf(forbidChar[i]) >= 0){ 
			      		return false;
				  	} 
				}   
				return true;
			},
			/**
			 * 检查是否全部是数字
			 * @param 	str 字符串
			 * @return 	bool
			 * @author	szj
			*/
			checkNum:function(str){
			  return /^[0-9]*$/.test(str);
			},
			/**
			 * 检查数组里面是否有重复元素 
			 * @param	array 数组
			 * @return 	bool
			 * @author	szj
			*/
			checkArrayRepeat:function(array){ 
				var hash = {}; 
				for(var i in array) { 
					if(hash[array[i]]) 
						return true; 
					hash[array[i]] = true; 
				} 
				return false;
			},
			/**
			 * 检查数组是否含有某元素 
			 * @param	array 数组
			 * @param	item  元素
			 * @return	index 是则返回数组中重复元素序号，否则返回-1
			 * @author	szj
			*/
			arrayCheckItem:function(array,item){
				var index = -1;
				for (var i=0; i<array.length; i++) {
					if(array[i]==item){
						index=i;
						break;
					}
				}
				return index;
			},
			/**
			 * 检查是否为数字
			 * @param	str 字符串
			 * @return	bool
			 * @author	szj
			*/
			f_check_number:function(str){ 
				return /^\d+$/.test(str);
			},
			/**
			 * 检查是否为自然数
			 * @param	str 字符串
			 * @return	bool
			 * @author	szj
			*/
			f_check_naturalnumber:function(str){  
			    return (/^[0-9]+$/.test(str) && (str> 0));
			},
			/**
			 * 检查是否为整数
			 * @param	str 字符串
			 * @return	bool
			 * @author	szj
			*/
			f_check_integer:function(str){           
			    return /^(\+|-)?\d+$/.test(str);
			},
			/**
			 * 检查是否为实数
			 * @param	str 字符串
			 * @return	bool
			 * @author	szj
			*/
			f_check_float:function(str){           
			    return /^(\+|-)?\d+($|\.\d+$)/.test(str);
			},
			/**
			 * 检查输入字符串是否只由汉字组成 
			 * @param	str 字符串
			 * @return	bool
			 * @author	szj
			*/
			f_check_zh:function(str){    
			   return /^[\u4e00-\u9fa5]+$/.test(str);  
			},
			/**
			 * 检查是否为小写英文字母 
			 * @param	str 字符串
			 * @return	bool
			 * @author	szj
			*/
			f_check_lowercase:function(str){        
			    return /^[a-z]+$/.test(str);
			},
			/**
			 * 检查是否为大写英文字母 
			 * @param	str 字符串
			 * @return	bool
			 * @author	szj
			*/
			f_check_uppercase:function(str){           
			   	return /^[A-Z]+$/.test(str);    
			},
			/**
			 * 检查是否为英文字母 
			 * @param	str 字符串
			 * @return	bool
			 * @author	szj
			*/
			f_check_letter:function(str){           
			    return /^[A-Za-z]+$/.test(str);
			},
			/**
			 * 检查输入字符串是否只由汉字、字母、数字组成 
			 * @param	str 字符串
			 * @return	bool
			 * @author	szj
			*/
			f_check_ZhOrNumOrLett:function(str){   
			    return /^[0-9a-zA-Z\u4e00-\u9fa5]+$/.test(str);    
			},
			/**
			 * 校验ip地址的格式 
			 * @param	str 字符串
			 * @return	bool
			 * @author	szj
			*/
			f_check_IP:function(str){     
			    var re=/^(\d+)\.(\d+)\.(\d+)\.(\d+)$/;    
			    if(re.test( str )){    
			        if (RegExp.$1 < 256 && RegExp.$2 < 256 && RegExp.$3 < 256 && RegExp.$4 < 256) {
						return true;
					}    
			    }
			    return false;     
			},
			/**
			 * 检查是否符合端口号格式 
			 * @param	str 字符串
			 * @return	bool
			 * @author	szj
			*/
			f_check_port:function(str){ 
				return (this.f_check_number(str) && str < 65536);  
			},
			/**
			 * 检查是否符合E-Mail格式  
			 * @param	str 字符串
			 * @return	bool
			 * @author	szj
			*/
			f_check_email:function(str){        
				return /^([-_A-Za-z0-9\.]+)@([_A-Za-z0-9]+\.)+[A-Za-z0-9]{2,3}$/.test(str);    
			},
			/**
			 * 检查输入手机号码是否正确 
			 * @param	str 字符串
			 * @return	bool
			 * @author	szj
			*/
			f_check_mobile:function(str){       
			    return /(^[1][0-9][0-9]{9}$)|(^0[1][3][0-9]{9}$)/.test(str);
			},
			/**
			 * 检查输入的电话号码格式是否正确 区号如果输入,则格式为 "0571-" or "(0571)"
			 * @param	str 字符串
			 * @return	bool
			 * @author	szj
			*/
			f_check_phone:function(str){    
			    return /(^([0][1-9]{2,3}[-])?\d{3,8}(-\d{1,6})?$)|(^\([0][1-9]{2,3}\)\d{3,8}(\(\d{1,6}\))?$)|(^\d{3,8}$)/.test(str);   
			},
			/**
			 * 检查是否为邮政编码
			 * @param	str 字符串
			 * @return	bool
			 * @author	szj
			*/
			f_check_zipcode:function(str){    
			    return (this.f_check_number(str) && str.length==6);   
			},
			/**
			 * 用户ID，可以为数字、字母、下划线的组合,第一个字符不能为数字,且总长度不能超过20。
			 * @param	str 字符串
			 * @return	bool
			 * @author	szj
			*/  
			f_check_userID:function(str){       
			    return str.length < 20 && isNaN(str.charAt(0)) && /^\w{1,20}$/.test(str);
			},
			/**
			 * 检查身份证号码是否有效,支持新的带x身份证
			 * @param	str 字符串
			 * @return	bool
			 * @author	szj
			*/  
			f_check_IDno:function(str){     
				var factorArr = new Array(7,9,10,5,8,4,2,1,6,3,7,9,10,5,8,4,2,1);
			     var error;
			     var varArray = new Array();
			     var intValue;
			     var lngProduct = 0;
			     var intCheckDigit;
			     var intStrLen = str.length;
			     var idNumber = str;    
			     if ((intStrLen != 15) && (intStrLen != 18)) {
			        return false;
			     }    
			     for(i=0;i<intStrLen;i++) {
			         varArray[i] = idNumber.charAt(i);
			         if ((varArray[i] < '0' || varArray[i] > '9') && (i != 17)) {
			             return false;
			         } else if (i < 17) {
			        	 varArray[i] = varArray[i]*factorArr[i];
			         }
			     }
			     if (intStrLen == 18) {
			         var date8 = idNumber.substring(6,14);
			         if (this.f_check_IDnoDate(idNumber,true) == false) {
			            return false;
			         }       
			         for(i=0;i<17;i++) {
			             lngProduct = lngProduct + varArray[i];
			         }        
			        intCheckDigit = 12 - lngProduct % 11;
			         switch (intCheckDigit) {
			             case 10:
			                 intCheckDigit = 'X';
			                 break;
			             case 11:
			                 intCheckDigit = 0;
			                 break;
			             case 12:
			                 intCheckDigit = 1;
			                 break;
			         }        
			     }else{       
			         var date6 = idNumber.substring(6,12);
			         date6 = '19'+date6;
			         if (this.f_check_IDnoDate(idNumber,false) == false) {
			             return false;
			         }
			     }
			     return true;
			},
			/**
			 * 检查身份证号码中的时间,供f_check_IDno调用
			 * @param	idcard	身份证号码
			 * @param	is18 	是否18位号码
			 * @return	bool
			 * @author	szj
			*/
            f_check_IDnoDate: function(idcard, is18){
                var ereg;
                if (is18) {
                    if (parseInt(idcard.substring(6, 10)) % 4 == 0 || (parseInt(idcard.substring(6, 10)) % 100 == 0 && parseInt(idcard.substring(6, 10)) % 4 == 0)) {
                        ereg = /^[1-9][0-9]{5}19[0-9]{2}((01|03|05|07|08|10|12)(0[1-9]|[1-2][0-9]|3[0-1])|(04|06|09|11)(0[1-9]|[1-2][0-9]|30)|02(0[1-9]|[1-2][0-9]))[0-9]{3}[0-9Xx]$/;//闰年出生日期的合法性正则表达式    
                    }
                    else {
                        ereg = /^[1-9][0-9]{5}19[0-9]{2}((01|03|05|07|08|10|12)(0[1-9]|[1-2][0-9]|3[0-1])|(04|06|09|11)(0[1-9]|[1-2][0-9]|30)|02(0[1-9]|1[0-9]|2[0-8]))[0-9]{3}[0-9Xx]$/;//平年出生日期的合法性正则表达式    
                    }
                }
                else {
                    if ((parseInt(idcard.substr(6, 8)) + 1900) % 4 == 0 || ((parseInt(idcard.substr(6, 8)) + 1900) % 100 == 0 && (parseInt(idcard.substr(6, 8)) + 1900) % 4 == 0)) {
                        ereg = /^[1-9][0-9]{5}[0-9]{2}((01|03|05|07|08|10|12)(0[1-9]|[1-2][0-9]|3[0-1])|(04|06|09|11)(0[1-9]|[1-2][0-9]|30)|02(0[1-9]|[1-2][0-9]))[0-9]{3}$/;//测试出生日期的合法性    
                    }
                    else {
                        ereg = /^[1-9][0-9]{5}[0-9]{2}((01|03|05|07|08|10|12)(0[1-9]|[1-2][0-9]|3[0-1])|(04|06|09|11)(0[1-9]|[1-2][0-9]|30)|02(0[1-9]|1[0-9]|2[0-8]))[0-9]{3}$/;//测试出生日期的合法性    
                    }
                }
                if (ereg.test(idcard)) {
                    return true;
                }
                else {
                    return false;
                }
            }
			
		}	
	});
})(jQuery);




